/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.generators;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class ModelProvider<T extends ModelBuilder<T>>
implements class_2405 {
    public static final String BLOCK_FOLDER = "block";
    public static final String ITEM_FOLDER = "item";
    protected static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(class_3264.field_14188, ".png", "textures");
    protected static final ExistingFileHelper.ResourceType MODEL = new ExistingFileHelper.ResourceType(class_3264.field_14188, ".json", "models");
    protected static final ExistingFileHelper.ResourceType MODEL_WITH_EXTENSION = new ExistingFileHelper.ResourceType(class_3264.field_14188, "", "models");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final class_7784 output;
    protected final String modid;
    protected final String folder;
    protected final Function<class_2960, T> factory;
    @VisibleForTesting
    public final Map<class_2960, T> generatedModels = new HashMap<class_2960, T>();
    @VisibleForTesting
    public final ExistingFileHelper existingFileHelper;

    protected abstract void registerModels();

    public ModelProvider(class_7784 output, String modid, String folder, Function<class_2960, T> factory, ExistingFileHelper existingFileHelper) {
        Preconditions.checkNotNull((Object)output);
        this.output = output;
        Preconditions.checkNotNull((Object)modid);
        this.modid = modid;
        Preconditions.checkNotNull((Object)folder);
        this.folder = folder;
        Preconditions.checkNotNull(factory);
        this.factory = factory;
        Preconditions.checkNotNull((Object)existingFileHelper);
        this.existingFileHelper = existingFileHelper;
    }

    public ModelProvider(class_7784 output, String modid, String folder, BiFunction<class_2960, ExistingFileHelper, T> builderFromModId, ExistingFileHelper existingFileHelper) {
        this(output, modid, folder, (class_2960 loc) -> (ModelBuilder)builderFromModId.apply((class_2960)loc, existingFileHelper), existingFileHelper);
    }

    public T getBuilder(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        class_2960 outputLoc = this.extendWithFolder(path.contains(":") ? new class_2960(path) : new class_2960(this.modid, path));
        this.existingFileHelper.trackGenerated(outputLoc, (ExistingFileHelper.IResourceType)MODEL);
        return (T)((ModelBuilder)this.generatedModels.computeIfAbsent(outputLoc, this.factory));
    }

    private class_2960 extendWithFolder(class_2960 rl) {
        if (rl.method_12832().contains("/")) {
            return rl;
        }
        return new class_2960(rl.method_12836(), this.folder + "/" + rl.method_12832());
    }

    public class_2960 modLoc(String name) {
        return new class_2960(this.modid, name);
    }

    public class_2960 mcLoc(String name) {
        return new class_2960(name);
    }

    public T withExistingParent(String name, String parent) {
        return this.withExistingParent(name, this.mcLoc(parent));
    }

    public T withExistingParent(String name, class_2960 parent) {
        return ((ModelBuilder)this.getBuilder(name)).parent(this.getExistingFile(parent));
    }

    public T cube(String name, class_2960 down, class_2960 up, class_2960 north, class_2960 south, class_2960 east, class_2960 west) {
        return ((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "cube")).texture("down", down)).texture("up", up)).texture("north", north)).texture("south", south)).texture("east", east)).texture("west", west);
    }

    private T singleTexture(String name, String parent, class_2960 texture) {
        return this.singleTexture(name, this.mcLoc(parent), texture);
    }

    public T singleTexture(String name, class_2960 parent, class_2960 texture) {
        return this.singleTexture(name, parent, "texture", texture);
    }

    private T singleTexture(String name, String parent, String textureKey, class_2960 texture) {
        return this.singleTexture(name, this.mcLoc(parent), textureKey, texture);
    }

    public T singleTexture(String name, class_2960 parent, String textureKey, class_2960 texture) {
        return ((ModelBuilder)this.withExistingParent(name, parent)).texture(textureKey, texture);
    }

    public T cubeAll(String name, class_2960 texture) {
        return this.singleTexture(name, "block/cube_all", "all", texture);
    }

    public T cubeTop(String name, class_2960 side, class_2960 top) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/cube_top")).texture("side", side)).texture("top", top);
    }

    private T sideBottomTop(String name, String parent, class_2960 side, class_2960 bottom, class_2960 top) {
        return ((ModelBuilder)((ModelBuilder)((ModelBuilder)this.withExistingParent(name, parent)).texture("side", side)).texture("bottom", bottom)).texture("top", top);
    }

    public T cubeBottomTop(String name, class_2960 side, class_2960 bottom, class_2960 top) {
        return this.sideBottomTop(name, "block/cube_bottom_top", side, bottom, top);
    }

    public T cubeColumn(String name, class_2960 side, class_2960 end) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/cube_column")).texture("side", side)).texture("end", end);
    }

    public T cubeColumnHorizontal(String name, class_2960 side, class_2960 end) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/cube_column_horizontal")).texture("side", side)).texture("end", end);
    }

    public T orientableVertical(String name, class_2960 side, class_2960 front) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/orientable_vertical")).texture("side", side)).texture("front", front);
    }

    public T orientableWithBottom(String name, class_2960 side, class_2960 front, class_2960 bottom, class_2960 top) {
        return ((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/orientable_with_bottom")).texture("side", side)).texture("front", front)).texture("bottom", bottom)).texture("top", top);
    }

    public T orientable(String name, class_2960 side, class_2960 front, class_2960 top) {
        return ((ModelBuilder)((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/orientable")).texture("side", side)).texture("front", front)).texture("top", top);
    }

    public T crop(String name, class_2960 crop) {
        return this.singleTexture(name, "block/crop", "crop", crop);
    }

    public T cross(String name, class_2960 cross) {
        return this.singleTexture(name, "block/cross", "cross", cross);
    }

    public T stairs(String name, class_2960 side, class_2960 bottom, class_2960 top) {
        return this.sideBottomTop(name, "block/stairs", side, bottom, top);
    }

    public T stairsOuter(String name, class_2960 side, class_2960 bottom, class_2960 top) {
        return this.sideBottomTop(name, "block/outer_stairs", side, bottom, top);
    }

    public T stairsInner(String name, class_2960 side, class_2960 bottom, class_2960 top) {
        return this.sideBottomTop(name, "block/inner_stairs", side, bottom, top);
    }

    public T slab(String name, class_2960 side, class_2960 bottom, class_2960 top) {
        return this.sideBottomTop(name, "block/slab", side, bottom, top);
    }

    public T slabTop(String name, class_2960 side, class_2960 bottom, class_2960 top) {
        return this.sideBottomTop(name, "block/slab_top", side, bottom, top);
    }

    public T button(String name, class_2960 texture) {
        return this.singleTexture(name, "block/button", texture);
    }

    public T buttonPressed(String name, class_2960 texture) {
        return this.singleTexture(name, "block/button_pressed", texture);
    }

    public T buttonInventory(String name, class_2960 texture) {
        return this.singleTexture(name, "block/button_inventory", texture);
    }

    public T pressurePlate(String name, class_2960 texture) {
        return this.singleTexture(name, "block/pressure_plate_up", texture);
    }

    public T pressurePlateDown(String name, class_2960 texture) {
        return this.singleTexture(name, "block/pressure_plate_down", texture);
    }

    public T sign(String name, class_2960 texture) {
        return ((ModelBuilder)this.getBuilder(name)).texture("particle", texture);
    }

    public T fencePost(String name, class_2960 texture) {
        return this.singleTexture(name, "block/fence_post", texture);
    }

    public T fenceSide(String name, class_2960 texture) {
        return this.singleTexture(name, "block/fence_side", texture);
    }

    public T fenceInventory(String name, class_2960 texture) {
        return this.singleTexture(name, "block/fence_inventory", texture);
    }

    public T fenceGate(String name, class_2960 texture) {
        return this.singleTexture(name, "block/template_fence_gate", texture);
    }

    public T fenceGateOpen(String name, class_2960 texture) {
        return this.singleTexture(name, "block/template_fence_gate_open", texture);
    }

    public T fenceGateWall(String name, class_2960 texture) {
        return this.singleTexture(name, "block/template_fence_gate_wall", texture);
    }

    public T fenceGateWallOpen(String name, class_2960 texture) {
        return this.singleTexture(name, "block/template_fence_gate_wall_open", texture);
    }

    public T wallPost(String name, class_2960 wall) {
        return this.singleTexture(name, "block/template_wall_post", "wall", wall);
    }

    public T wallSide(String name, class_2960 wall) {
        return this.singleTexture(name, "block/template_wall_side", "wall", wall);
    }

    public T wallSideTall(String name, class_2960 wall) {
        return this.singleTexture(name, "block/template_wall_side_tall", "wall", wall);
    }

    public T wallInventory(String name, class_2960 wall) {
        return this.singleTexture(name, "block/wall_inventory", "wall", wall);
    }

    private T pane(String name, String parent, class_2960 pane, class_2960 edge) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/" + parent)).texture("pane", pane)).texture("edge", edge);
    }

    public T panePost(String name, class_2960 pane, class_2960 edge) {
        return this.pane(name, "template_glass_pane_post", pane, edge);
    }

    public T paneSide(String name, class_2960 pane, class_2960 edge) {
        return this.pane(name, "template_glass_pane_side", pane, edge);
    }

    public T paneSideAlt(String name, class_2960 pane, class_2960 edge) {
        return this.pane(name, "template_glass_pane_side_alt", pane, edge);
    }

    public T paneNoSide(String name, class_2960 pane) {
        return this.singleTexture(name, "block/template_glass_pane_noside", "pane", pane);
    }

    public T paneNoSideAlt(String name, class_2960 pane) {
        return this.singleTexture(name, "block/template_glass_pane_noside_alt", "pane", pane);
    }

    private T door(String name, String model, class_2960 bottom, class_2960 top) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/" + model)).texture("bottom", bottom)).texture("top", top);
    }

    public T doorBottomLeft(String name, class_2960 bottom, class_2960 top) {
        return this.door(name, "door_bottom_left", bottom, top);
    }

    public T doorBottomLeftOpen(String name, class_2960 bottom, class_2960 top) {
        return this.door(name, "door_bottom_left_open", bottom, top);
    }

    public T doorBottomRight(String name, class_2960 bottom, class_2960 top) {
        return this.door(name, "door_bottom_right", bottom, top);
    }

    public T doorBottomRightOpen(String name, class_2960 bottom, class_2960 top) {
        return this.door(name, "door_bottom_right_open", bottom, top);
    }

    public T doorTopLeft(String name, class_2960 bottom, class_2960 top) {
        return this.door(name, "door_top_left", bottom, top);
    }

    public T doorTopLeftOpen(String name, class_2960 bottom, class_2960 top) {
        return this.door(name, "door_top_left_open", bottom, top);
    }

    public T doorTopRight(String name, class_2960 bottom, class_2960 top) {
        return this.door(name, "door_top_right", bottom, top);
    }

    public T doorTopRightOpen(String name, class_2960 bottom, class_2960 top) {
        return this.door(name, "door_top_right_open", bottom, top);
    }

    public T trapdoorBottom(String name, class_2960 texture) {
        return this.singleTexture(name, "block/template_trapdoor_bottom", texture);
    }

    public T trapdoorTop(String name, class_2960 texture) {
        return this.singleTexture(name, "block/template_trapdoor_top", texture);
    }

    public T trapdoorOpen(String name, class_2960 texture) {
        return this.singleTexture(name, "block/template_trapdoor_open", texture);
    }

    public T trapdoorOrientableBottom(String name, class_2960 texture) {
        return this.singleTexture(name, "block/template_orientable_trapdoor_bottom", texture);
    }

    public T trapdoorOrientableTop(String name, class_2960 texture) {
        return this.singleTexture(name, "block/template_orientable_trapdoor_top", texture);
    }

    public T trapdoorOrientableOpen(String name, class_2960 texture) {
        return this.singleTexture(name, "block/template_orientable_trapdoor_open", texture);
    }

    public T torch(String name, class_2960 torch) {
        return this.singleTexture(name, "block/template_torch", "torch", torch);
    }

    public T torchWall(String name, class_2960 torch) {
        return this.singleTexture(name, "block/template_torch_wall", "torch", torch);
    }

    public T carpet(String name, class_2960 wool) {
        return this.singleTexture(name, "block/carpet", "wool", wool);
    }

    public T nested() {
        return (T)((ModelBuilder)this.factory.apply(new class_2960("dummy:dummy")));
    }

    public ModelFile.ExistingModelFile getExistingFile(class_2960 path) {
        ModelFile.ExistingModelFile ret = new ModelFile.ExistingModelFile(this.extendWithFolder(path), this.existingFileHelper);
        ret.assertExistence();
        return ret;
    }

    public void clear() {
        this.generatedModels.clear();
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.clear();
        this.registerModels();
        return this.generateAll(cache);
    }

    public CompletableFuture<?> generateAll(class_7403 cache) {
        CompletableFuture[] futures = new CompletableFuture[this.generatedModels.size()];
        int i = 0;
        for (ModelBuilder model : this.generatedModels.values()) {
            Path target = this.getPath(model);
            futures[i++] = class_2405.method_10320((class_7403)cache, (JsonElement)model.toJson(), (Path)target);
        }
        return CompletableFuture.allOf(futures);
    }

    protected Path getPath(T model) {
        class_2960 loc = ((ModelFile)model).getLocation();
        return this.output.method_45972(class_7784.class_7490.field_39368).resolve(loc.method_12836()).resolve("models").resolve(loc.method_12832() + ".json");
    }
}

